/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.worldgen.world;

import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.worldgen.WorldGenModule;
import mcjty.deepresonance.modules.worldgen.util.WorldGenConfiguration;
import mcjty.deepresonance.modules.worldgen.world.ResonantCrystalFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ResonantCrystalFeature
extends Feature<ResonantCrystalFeatureConfig> {
    public static final ResourceLocation FEATURE_CRYSTAL_ID = new ResourceLocation("deepresonance", "resonant_crystal");
    public static Holder<PlacedFeature> CRYSTAL_CONFIGURED_OVERWORLD;
    public static Holder<PlacedFeature> CRYSTAL_CONFIGURED_NETHER;
    public static Holder<PlacedFeature> CRYSTAL_CONFIGURED_END;

    public ResonantCrystalFeature(Codec<ResonantCrystalFeatureConfig> codec) {
        super(codec);
    }

    public static void registerConfiguredFeatures() {
        CRYSTAL_CONFIGURED_OVERWORLD = ResonantCrystalFeature.registerPlacedFeature("configured_crystal_overworld", new ConfiguredFeature((Feature)((ResonantCrystalFeature)((Object)WorldGenModule.CRYSTAL_FEATURE.get())), (FeatureConfiguration)new ResonantCrystalFeatureConfig(1.0f, 1.0f, 1.0f, 1.0f)), new PlacementModifier[]{CountPlacement.m_191628_((int)1)});
        CRYSTAL_CONFIGURED_NETHER = ResonantCrystalFeature.registerPlacedFeature("configured_crystal_nether", new ConfiguredFeature((Feature)((ResonantCrystalFeature)((Object)WorldGenModule.CRYSTAL_FEATURE.get())), (FeatureConfiguration)new ResonantCrystalFeatureConfig(1.0f, 1.0f, 1.0f, 1.0f)), new PlacementModifier[]{CountPlacement.m_191628_((int)1)});
        CRYSTAL_CONFIGURED_END = ResonantCrystalFeature.registerPlacedFeature("configured_crystal_end", new ConfiguredFeature((Feature)((ResonantCrystalFeature)((Object)WorldGenModule.CRYSTAL_FEATURE.get())), (FeatureConfiguration)new ResonantCrystalFeatureConfig(1.0f, 1.0f, 1.0f, 1.0f)), new PlacementModifier[]{CountPlacement.m_191628_((int)1)});
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> Holder<PlacedFeature> registerPlacedFeature(String registryName, ConfiguredFeature<C, F> feature, PlacementModifier ... placementModifiers) {
        return PlacementUtils.m_206513_((String)registryName, (Holder)Holder.m_205709_(feature), (PlacementModifier[])placementModifiers);
    }

    public boolean m_142674_(FeaturePlaceContext<ResonantCrystalFeatureConfig> context) {
        if (context.m_159776_().nextDouble() < (Double)WorldGenConfiguration.CRYSTAL_SPAWN_CHANCE.get()) {
            return this.trySpawnCrystal(context.m_159774_(), context.m_159775_(), new ChunkPos(context.m_159777_()), context.m_159776_(), (ResonantCrystalFeatureConfig)context.m_159778_());
        }
        return false;
    }

    private boolean trySpawnCrystal(@Nonnull WorldGenLevel world, @Nonnull ChunkGenerator generator, ChunkPos chunkPos, Random random, ResonantCrystalFeatureConfig config) {
        for (int i = 0; i < (Integer)WorldGenConfiguration.CRYSTAL_SPAWN_TRIES.get(); ++i) {
            BlockPos pos = new BlockPos(chunkPos.m_45604_() + random.nextInt(16), 0, chunkPos.m_45605_() + random.nextInt(16));
            int y = world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
            pos = new BlockPos(pos.m_123341_(), y - 1, pos.m_123343_());
            BlockPos.MutableBlockPos poz = pos.m_122032_();
            while (poz.m_123342_() > world.m_141937_() && !world.m_8055_((BlockPos)poz).m_60795_()) {
                poz.m_122173_(Direction.DOWN);
            }
            while (poz.m_123342_() > world.m_141937_() && world.m_8055_((BlockPos)poz).m_60795_()) {
                poz.m_122173_(Direction.DOWN);
            }
            if (!world.m_8055_((BlockPos)poz).m_60838_((BlockGetter)world, (BlockPos)poz) || !world.m_8055_(pos = poz.m_7494_()).m_60795_()) continue;
            if (((Boolean)WorldGenConfiguration.VERBOSE.get()).booleanValue()) {
                DeepResonance.setup.getLogger().info("Spawned crystal at: " + pos);
            }
            ResonantCrystalFeature.spawnRandomCrystal(world, random, pos, config.strength, config.power, config.efficiency, config.purity);
            return true;
        }
        return false;
    }

    public static void spawnRandomCrystal(WorldGenLevel world, Random random, BlockPos pos, float str, float pow, float eff, float pur) {
        world.m_7731_(pos, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_NATURAL.get())).m_49966_(), 3);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity tile = (ResonatingCrystalTileEntity)te;
            tile.setStrength(Math.min(100.0f, random.nextFloat() * str * 3.0f + 0.01f));
            tile.setPower(Math.min(100.0f, random.nextFloat() * pow * 60.0f + 0.2f));
            tile.setEfficiency(Math.min(100.0f, random.nextFloat() * eff * 3.0f + 0.1f));
            tile.setPurity(Math.min(100.0f, random.nextFloat() * pur * 10.0f + 5.0f));
        }
    }
}

